package pro.spss.server.agent.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import pro.spss.server.agent.domain.entity.AiChatResponse;

import java.util.ArrayList;

public class JsonToObjectConverter {

    public static AiChatResponse convertJsonToObject(String jsonString) {
        AiChatResponse aiChatResponse = new AiChatResponse();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readValue(jsonString, AiChatResponse.class);
        } catch (JsonParseException e) {
            System.out.println("JSON转换失败");
            aiChatResponse.setResponse(jsonString);
            aiChatResponse.setRecommendedAlgorithms(new ArrayList<>());
            return aiChatResponse;
        } catch (Exception e) {
            e.printStackTrace();
            aiChatResponse.setResponse("似乎出现了点问题，我的大脑有点出小差了。");
            aiChatResponse.setRecommendedAlgorithms(new ArrayList<>());
            return aiChatResponse;
        }
    }

}
