package pro.spss.server.agent.service.prompt;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 通用提示词构建服务：
 * - 可对单个提示词按配置添加 /no_think 前缀
 * - TODO 可从提示词数组中按索引选择一个提示词，并按配置添加前缀
 */
@Service
public class PromptBuilderService {

    @Value("${agent.api.think:false}")
    private boolean agentApiThink;

    /**
     * 为单个提示词添加必要的前缀（若 agentApiThink=true 则添加 /no_think）。
     */
    public String build(String prompt) {
        if (prompt == null) return "";
        return agentApiThink ? prompt : "/no_think\n" + prompt;
    }

}

