package pro.spss.server.agent.service.messageService;

import com.alibaba.fastjson2.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pro.spss.server.agent.domain.enums.MessageType;
import pro.spss.server.agent.domain.enums.RoleType;
import pro.spss.server.agent.domain.pojo.DaAgentMessage;
import pro.spss.server.agent.domain.request.UserChatMessage;
import pro.spss.server.agent.mapper.DaAgentMessageMapper;

import java.util.Date;
import java.util.List;

@Service
public class MessageService {

    @Autowired
    private DaAgentMessageMapper messageMapper;

    public DaAgentMessage addMessage(Long sessionId, String role, String content, String think, String toolName) {
        DaAgentMessage m = new DaAgentMessage();
        m.setSessionId(sessionId);
        m.setRole(role);
        m.setContent(content);
        m.setThink(think);
        m.setToolName(toolName);
        m.setType(MessageType.MESSAGE.getType());
        messageMapper.insert(m);
        return m;
    }

    public DaAgentMessage addMessage(Long sessionId, String role, String content, String think, String toolName, String type) {
        DaAgentMessage m = new DaAgentMessage();
        m.setSessionId(sessionId);
        m.setRole(role);
        m.setContent(content);
        m.setThink(think);
        m.setToolName(toolName);
        m.setType(type);
        messageMapper.insert(m);
        return m;
    }

    public DaAgentMessage addUserMessage(Long sessionId, String content, UserChatMessage userChatMessage) {
        DaAgentMessage m = new DaAgentMessage();
        m.setSessionId(sessionId);
        m.setRole(RoleType.USER.getType());
        m.setContent(content);
        m.setThink(null);
        m.setToolName(null);
        m.setType(MessageType.ASK.getType());
        m.setMetadata(JSONObject.toJSONString(userChatMessage));
        messageMapper.insert(m);
        return m;
    }


    // 新增：带type/起止时间戳的插入
    public DaAgentMessage addMessage(Long sessionId,
                                     String role,
                                     String content,
                                     String think,
                                     String toolName,
                                     Integer totalToken,
                                     String type,
                                     long startTimestamp,
                                     long endTimestamp) {
        DaAgentMessage m = new DaAgentMessage();
        m.setSessionId(sessionId);
        m.setRole(role);
        m.setContent(content);
        m.setThink(think);
        m.setToolName(toolName);
        m.setTokens(totalToken);
        m.setType(type);
        m.setStartTimestamp(startTimestamp);
        m.setEndTimestamp(endTimestamp);
        messageMapper.insert(m);
        return m;
    }

    public DaAgentMessage addMessage(Long sessionId,
                                     String role,
                                     String content,
                                     String think,
                                     String toolName,
                                     Integer totalToken,
                                     String type,
                                     JSONObject metadata,
                                     long startTimestamp,
                                     long endTimestamp) {
        DaAgentMessage m = new DaAgentMessage();
        m.setSessionId(sessionId);
        m.setRole(role);
        m.setContent(content);
        m.setThink(think);
        m.setToolName(toolName);
        m.setTokens(totalToken);
        m.setType(type);
        m.setMetadata(metadata.toJSONString());
        m.setStartTimestamp(startTimestamp);
        m.setEndTimestamp(endTimestamp);
        messageMapper.insert(m);
        return m;
    }

    public DaAgentMessage addMessage(Long sessionId,
                                     String role,
                                     String content,
                                     String think,
                                     String toolName,
                                     Integer totalToken,
                                     String type,
                                     String metadata,
                                     long startTimestamp,
                                     long endTimestamp) {
        DaAgentMessage m = new DaAgentMessage();
        m.setSessionId(sessionId);
        m.setRole(role);
        m.setContent(content);
        m.setThink(think);
        m.setToolName(toolName);
        m.setTokens(totalToken);
        m.setType(type);
        m.setMetadata(metadata);
        m.setStartTimestamp(startTimestamp);
        m.setEndTimestamp(endTimestamp);
        messageMapper.insert(m);
        return m;
    }

    // 新增：按ID更新部分字段（例如补充endTimestamp、tokens等）
    public int updateMessage(DaAgentMessage partial) {
        if (partial.getMessageId() == null) {
            throw new IllegalArgumentException("messageId is required for update");
        }
        return messageMapper.updateById(partial);
    }

    public List<DaAgentMessage> listBySession(Long sessionId, int page, int pageSize, String role) {
        int offset = Math.max(0, (page - 1) * pageSize);
        return messageMapper.listBySession(sessionId, offset, pageSize, role);
    }

    public int countBySession(Long sessionId, String role) {
        return messageMapper.countBySession(sessionId, role);
    }

    // 新增：一次性拉取该会话的所有消息（仅用户与助手角色）
    public List<DaAgentMessage> listAllBySession(Long sessionId) {
        // 复用现有SQL：传null role且limit给一个大值
        return messageMapper.listBySession(sessionId, 0, Integer.MAX_VALUE, null);
    }

    // 提交反馈（评分、内容、时间）
    public int submitFeedback(Long messageId, Integer rating, String content, Date feedbackAt) {
        DaAgentMessage partial = new DaAgentMessage();
        partial.setMessageId(messageId);
        partial.setFeedbackRating(rating);
        partial.setFeedbackContent(content);
        partial.setFeedbackAt(feedbackAt);
        return messageMapper.updateById(partial);
    }

    // 便捷：毫秒时间戳版本（0或null不更新）
    public int submitFeedback(Long messageId, Integer rating, String content, Long feedbackAtMs) {
        Date at = (feedbackAtMs != null && feedbackAtMs != 0) ? new Date(feedbackAtMs) : null;
        return submitFeedback(messageId, rating, content, at);
    }

    // 设置收藏状态
    public int setCollected(Long messageId, Boolean collected) {
        DaAgentMessage partial = new DaAgentMessage();
        partial.setMessageId(messageId);
        partial.setIsCollected(collected);
        return messageMapper.updateById(partial);
    }

    public DaAgentMessage findLastUserMessage(Long sessionId) {
        return messageMapper.findLastByRole(sessionId, "user");
    }

    public DaAgentMessage findLastAssistantMessage(Long sessionId) {
        return messageMapper.findLastByRole(sessionId, "assistant");
    }

    public int deleteLastAssistantMessage(Long sessionId) {
        return messageMapper.deleteLastAssistantBySession(sessionId);
    }

}
