package pro.spss.server.agent.service.handler.tools;

import com.alibaba.fastjson2.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.request.RequestParams;
import pro.spss.server.agent.domain.response.ResponseMessage;
import pro.spss.server.agent.service.taskExecutor.TaskExecutor;

import java.io.IOException;

/**
 * 算法执行处理器
 */
@Component
public class AlgoExecutorHandler implements IntentStateHandler {

    private static final Logger logger = LoggerFactory.getLogger(AlgoExecutorHandler.class);

    @Autowired
    private TaskExecutor taskExecutor;

    @Override
    public String getName() { return "algo_executor"; }

    @Override
    public String getTitle() { return "算法执行工具"; }

    @Override
    public String getDesc() { return "这个是在算法确认以及参数确认后，根据用户上传的数据以及选择的算法，进行数据分析，并将结果返回给用户。当是否确认执行为是的时候，也选择该工具。"; }

    @Override
    public String exampleUserPrompt() {
        return "执行算法；执行；执行吧；可以执行";
    }

    @Override
    public String getCondition() {
        return "适用于是否确认执行为是；用户希望执行所选算法进行数据分析的场景。";
    }

    @Override
    public ResponseMessage handle(AiChatResponse intentResult, RequestParams requestParams, JSONArray messages, String prompt, String token) {
        logger.info("算法执行处理器");
        try {
            return taskExecutor.executeTask(requestParams, token);
        } catch (IOException e) {
            ResponseMessage msg = new ResponseMessage();
            msg.setCode(500);
            msg.setMessage("算法执行失败");
            msg.setResponse("算法执行失败");
            return msg;
        }
    }
}
