package pro.spss.server.agent.domain.response;

import java.util.ArrayList;
import java.util.List;

public class QueryResponse<T> {
    private int pageSize;
    private int pageNumber;
    private int count;
    private List<T> list;

    public QueryResponse() {
        list = new ArrayList<>();
    }

    public QueryResponse(int count, int pageSize, int pageNumber) {
        this.count = count;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    public QueryResponse(int count, int pageSize, int pageNumber, List<T> list) {
        this.count = count;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        this.list = list;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    /**
     * 找出 分页查询 改页码 应该从第几条记录开始limit
     * @return
     */
    public int getFirstIndex() {
        if(this.pageSize <= 0 ) { // 如果pageSize 小于 0， 将会设置成默认0
            this.pageSize = 10;
        }
        //计算总页数
        int totalPage = 0;
        if(this.count == 0) {
            totalPage = 0;
            return 0;
        }else {
            totalPage = this.count/this.pageSize;
            if(this.count%this.pageSize > 0) {
                totalPage = totalPage+1;
            }
        }

        // 如果pageNumber 小于0 则设置成第一页
        if(this.pageNumber<= 0){
            this.pageNumber = 1;
        } else if(this.pageNumber > totalPage) { // 如果pageNumber 大于最大页码数 则设置成最大页码
            this.pageNumber = totalPage;
        }
        return (this.pageNumber-1)*this.pageSize; //返回页面数
    }

}
