package pro.spss.server.agent.domain.constant;

import org.springframework.stereotype.Component;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.enums.IntentStatus;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * @author:wn
 * @Desc
 * @create: 2025-06-10-11:44
 **/
@Component
public class AlgoNameConfig {
    private final Map<String, String> algoNameToId = new HashMap<>();

    @PostConstruct
    public void load() {
        algoNameToId.put("最小二乘回归", "1");
        algoNameToId.put("岭回归", "2");
        algoNameToId.put("二分类逻辑回归", "3");
        algoNameToId.put("套索回归", "4");
        algoNameToId.put("多项式回归", "5");
        algoNameToId.put("支持向量机回归", "6");
        algoNameToId.put("BP神经网络", "7");
        algoNameToId.put("判别分析", "8");
        algoNameToId.put("决策树", "9");
        algoNameToId.put("随机森林", "10");
        algoNameToId.put("自适应增强算法", "11");
        algoNameToId.put("梯度提升树", "12");
        algoNameToId.put("K-均值聚类", "13");
        algoNameToId.put("k近邻法", "14");
        algoNameToId.put("层次聚类", "15");
        algoNameToId.put("因子分析", "16");
        algoNameToId.put("主成分分析", "17");
        algoNameToId.put("t检验", "18");
        algoNameToId.put("正态检验", "19");
        algoNameToId.put("关联规则挖掘法", "20");
        algoNameToId.put("皮尔逊相关分析", "21");
        algoNameToId.put("斯皮尔曼相关分析", "22");
        algoNameToId.put("移动平均法", "23");
        algoNameToId.put("指数平滑法", "24");
        algoNameToId.put("自回归模型（AR）", "25");
        algoNameToId.put("滑动平均模型（MA）", "26");
        algoNameToId.put("自回归滑动平均模型", "27");
        algoNameToId.put("差分自回归移动平均模型", "28");
        algoNameToId.put("优劣解距离法", "30");
        algoNameToId.put("弹性系数法", "31");
        algoNameToId.put("模糊综合评价", "33");
        algoNameToId.put("净现值法", "34");
        algoNameToId.put("秩和比评价法", "35");
        algoNameToId.put("区位熵分析", "36");
        algoNameToId.put("李克特量表", "37");
        algoNameToId.put("蒙特卡洛模拟", "38");
        algoNameToId.put("灰色模型", "39");
        algoNameToId.put("柯布-道格拉斯生产函数", "40");
        algoNameToId.put("描述性统计", "41");
        algoNameToId.put("标准化", "42");
        algoNameToId.put("区间缩放", "43");
        algoNameToId.put("非线性转换", "44");
        algoNameToId.put("归一化", "45");
        algoNameToId.put("二值化", "46");
        algoNameToId.put("哑编码", "47");
        algoNameToId.put("缺失值计算", "48");
        algoNameToId.put("多项式转换", "49");
        algoNameToId.put("自定义转换", "50");
        algoNameToId.put("层次分析法", "51");
        algoNameToId.put("数据包络分析（BCC）", "52");
        algoNameToId.put("数据包络分析（CCR）", "53");
    }

    public String getAlgoId(String name) {
        return algoNameToId.get(name);
    }

    public AiChatResponse matchAlgoNameInPrompt(String prompt) {
        AiChatResponse result = new AiChatResponse();

        for (Map.Entry<String, String> entry : algoNameToId.entrySet()) {
            String algoName = entry.getKey();
            if (prompt != null && prompt.contains(algoName)) {
                result.setHasIntent(IntentStatus.UserHasAglo.getState());
                result.setAlgoName(algoName);
                return result;
            }
        }
        result.setHasIntent(IntentStatus.NoIntent.getState());
        return result;
    }
}
