package pro.spss.server.agent.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;

public class TxtFileReader {
    public static String readFile(String filePath) {
        StringBuilder content = new StringBuilder();

        try (InputStream inputStream = TxtFileReader.class.getClassLoader().getResourceAsStream(filePath)) {
            assert inputStream != null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream))) {

                String line;
                while ((line = br.readLine()) != null) {
                    content.append(line).append(System.lineSeparator());
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return content.toString();
    }

    public static String readSystemFile(String filePath) {
        StringBuilder content = new StringBuilder();
        // 使用 java.nio.file.Files 来创建 BufferedReader
        try (BufferedReader br = Files.newBufferedReader(Paths.get(filePath))) {
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line).append(System.lineSeparator());
            }
        } catch (IOException e) {
            e.printStackTrace(); // 生产环境中应考虑更完善的错误处理
        }
        return content.toString();
    }
}
