package pro.spss.server.agent.utils;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import pro.spss.server.agent.domain.entity.ComputeResult;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

public class JsonUtil {

    /**
     * 从指定的文件路径读取 JSON 文件并解析为 List<Result>，且 List 中只有一个 Result 对象。
     *
     * @param filePath 要读取的 JSON 文件路径
     * @return 解析后的 List<Result> 对象
     */
    public static List<ComputeResult> readJsonFromFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
            StringWriter stringWriter = new StringWriter();
            String line;
            while ((line = reader.readLine()) != null) {
                stringWriter.write(line);
            }
            String jsonContent = stringWriter.toString();
            return JSONArray.parseArray(jsonContent, ComputeResult.class);
        }
    }

    public static String readJsonFileToString(String filePath) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        return content.toString();
    }

    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static boolean isValidJson(String jsonString) {
        // 基础检查：非空且以{或[开头
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return false;
        }
        String trimmed = jsonString.trim();
        if (!(trimmed.startsWith("{") || trimmed.startsWith("["))) {
            return false;
        }

        try {
            JsonNode jsonNode = objectMapper.readTree(jsonString);
            return jsonNode != null; // 解析成功且不为null
        } catch (JsonProcessingException e) {
            System.err.println("JSON解析错误: " + e.getMessage());
            return false;
        } catch (Exception e) {
            return false; // 其他异常也视为无效JSON
        }
    }
}
