package pro.spss.server.agent.utils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 * @author:wn
 * @Desc
 * @create: 2025-11-12-11:23
 **/
@Component
public class AgentFileReader {

    @Value("${path.csv-file}")
    private String csvFileBasePath;


    public String readCsvFileByDataId(String dataId, String userId) {
        if (dataId == null || dataId.trim().isEmpty()) {
            throw new IllegalArgumentException("dataId不能为空");
        }

        String filePath = buildFilePath(dataId, userId);
        StringBuilder result = new StringBuilder();

        try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
            String line;
            int lineCount = 0;

            while ((line = reader.readLine()) != null && lineCount < 4) { // 表头 + 前三行数据
                if (lineCount > 0) {
                    result.append("/n"); // 行间分隔符
                }

                String[] columns = line.split(",");
                for (int i = 0; i < columns.length; i++) {
                    if (i > 0) {
                        result.append("/t"); // 列间分隔符
                    }
                    result.append(columns[i]);
                }

                lineCount++;
            }
        } catch (IOException e) {
            throw new RuntimeException("读取CSV文件失败：" + e.getMessage(), e);
        }

        return result.toString();
    }

    private String buildFilePath(String dataId, String userId) {
        String basePath = csvFileBasePath.endsWith("/") ? csvFileBasePath : csvFileBasePath + "/";
        return basePath + userId + File.separator + dataId + "/data.csv";
    }
}