package pro.spss.server.agent.service.handler.tools;

import com.alibaba.fastjson2.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import pro.spss.server.agent.domain.constant.AlgoConfig;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.request.RequestParams;
import pro.spss.server.agent.domain.response.ResponseMessage;
import pro.spss.server.agent.service.chatCore.ChatHelper;
import pro.spss.server.agent.service.handler.ConversationSupport;
import pro.spss.server.agent.service.prompt.PromptBuilderService;

/**
 * 无意图（闲聊/引导）处理器
 */
//@Component
public class SystemInfoChatTool implements IntentStateHandler {

    private static final Logger logger = LoggerFactory.getLogger(SystemInfoChatTool.class);

    @Override
    public String getName() { return "system_info_chat"; }

    @Override
    public String getTitle() { return "算法介绍工具"; }

    @Override
    public String getDesc() { return "在用户没有上传数据的情况下询问算法情况，可以对算法的概念以及使用进行介绍等。"; }

    @Override
    public String exampleUserPrompt() {
        return "请帮我介绍一下什么是回归算法？";
    }

    @Override
    public String getCondition() {
        return "无";
    }

    @Autowired
    private ChatHelper chatHelper;

    @Value("${agent.handler_result}")
    private boolean handlerResult;

    @Autowired
    private PromptBuilderService promptBuilderService;

    @Autowired
    private ConversationSupport support;

    @Override
    public ResponseMessage handle(AiChatResponse intentResult, RequestParams requestParams, JSONArray historyMessages,
                                  String prompt, String token) {
        logger.info("闲聊阶段: 引导/闲聊");
        // 调用大模型识别
        String intentPrompt = promptBuilderService.build(AlgoConfig.SMART_CHAT_PROMPT);
        ResponseMessage msg = support.sendRequestWithHistoryMessages(historyMessages, intentPrompt, prompt);
        return msg;
    }
}
