package pro.spss.server.agent.service.handler.tools;

import com.alibaba.fastjson2.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import pro.spss.server.agent.domain.constant.AlgoConfig;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.request.RequestParams;
import pro.spss.server.agent.domain.response.ResponseMessage;
import pro.spss.server.agent.service.chatCore.ChatHelper;
import pro.spss.server.agent.service.handler.ConversationSupport;
import pro.spss.server.agent.service.prompt.PromptBuilderService;

/**
 * 无意图（闲聊/引导）处理器
 */
//@Component
public class SmartChatTool implements IntentStateHandler {

    private static final Logger logger = LoggerFactory.getLogger(SmartChatTool.class);

    @Override
    public String getName() { return "smart_chat"; }

    @Override
    public String getTitle() { return "闲聊工具"; }

    @Override
    public String getDesc() { return "能够根据用户的问题进行闲聊回复，回复内容包括打招呼，问候，询问系统功能，概念介绍等。当是否上传数据为否的时候，最好选择这个工具进行引导。"; }

    @Override
    public String exampleUserPrompt() {
        return "您好，能介绍一下你自己吗？请问系统中有哪些回归算法？";
    }

    @Override
    public String getCondition() {
        return "适用于用户没有上传数据集，且用户的问题属于闲聊/引导类问题的场景；也适用于用户上传了数据集，但问题属于闲聊/引导类问题的场景。";
    }

    @Autowired
    private ChatHelper chatHelper;

    @Autowired
    private PromptBuilderService promptBuilderService;

    @Autowired
    private ConversationSupport support;

    @Value("${agent.handler_result}")
    private boolean handlerResult;


    @Override
    public ResponseMessage handle(AiChatResponse intentResult, RequestParams requestParams, JSONArray historyMessages, String prompt, String token) {
        logger.info("闲聊阶段: 引导/闲聊");
        // 通过通用服务构建提示词（默认使用 AlgoConfig.SMART_CHAT_PROMPT）
        String intentPrompt = promptBuilderService.build(AlgoConfig.SMART_CHAT_PROMPT);
        ResponseMessage msg = support.sendRequestWithHistoryMessages(historyMessages, intentPrompt, prompt);
        return msg;
    }
}
