package pro.spss.server.agent.service.handler.tools;

import com.alibaba.fastjson2.JSONArray;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.request.RequestParams;
import pro.spss.server.agent.domain.response.ResponseMessage;

/**
 * 意图识别后的状态处理器接口（即工具）。
 * 仅保留工具元信息：name/title/desc/isExposed，以及执行方法 handle。
 * 为兼容历史调用，保留一个废弃的默认 getState()。
 */
public interface IntentStateHandler {
    // 工具唯一标识（供大模型输出使用）
    String getName();

    // 简短标题（如："算法推荐工具"）
    String getTitle();

    // 工具描述（用途与触发场景）
    String getDesc();

    String exampleUserPrompt();

    String getCondition();

    // 是否对外暴露给大模型进行选择，默认暴露
    default boolean isExposed() { return true; }

    // 兼容历史：默认返回 0，不建议使用
    @Deprecated
    default int getState() { return 0; }

    /**
     * 工具处理主入口
     */
    ResponseMessage handle(AiChatResponse intentResult,
                           RequestParams requestParams,
                           JSONArray messages,
                           String prompt,
                           String token);
}
