package pro.spss.server.agent.service.handler;

import org.springframework.stereotype.Component;
import pro.spss.server.agent.service.handler.tools.IntentStateHandler;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 工具注册中心：按 name 收集与查询
 */
@Component
public class IntentHandlerRegistry {
    private final Map<String, IntentStateHandler> handlersByName = new HashMap<>();

    public IntentHandlerRegistry(List<IntentStateHandler> handlerList) {
        if (handlerList != null) {
            for (IntentStateHandler h : handlerList) {
                handlersByName.put(h.getName(), h);
            }
        }
    }

    public IntentStateHandler get(String name) { return handlersByName.get(name); }

    // 对外工具清单（name, title, desc），仅包含暴露的工具，按 name 排序
    public List<Map<String, String>> getAllToolInfos() {
        return handlersByName.values().stream()
                .filter(IntentStateHandler::isExposed)
                .map(h -> {
                    Map<String, String> m = new HashMap<>();
                    m.put("name", h.getName());
                    m.put("title", h.getTitle());
                    m.put("desc", h.getDesc());
                    m.put("exampleUserPrompt", h.exampleUserPrompt());
                    m.put("condition", h.getCondition());
                    return m;
                })
                .sorted(Comparator.comparing(m -> m.get("name"), String.CASE_INSENSITIVE_ORDER))
                .collect(Collectors.toList());
    }
}
