package pro.spss.server.agent.service.handler;

import com.alibaba.fastjson2.JSONArray;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.request.RequestParams;
import pro.spss.server.agent.domain.request.UserChatMessage;
import pro.spss.server.agent.domain.response.ResponseMessage;
import pro.spss.server.agent.service.handler.tools.IntentStateHandler;

/**
 * ConversationHandler：路由控制器，负责把“意图识别结果”交给对应的状态处理器去处理。
 */
@Slf4j
@Component
public class ConversationHandler {

    private final IntentHandlerRegistry registry;

    public ConversationHandler(IntentHandlerRegistry registry) {
        this.registry = registry;
    }

    public ResponseMessage toolExecutor(RequestParams requestParams,
                                                   UserChatMessage userChatMessage,
                                                   String selectedTool,
                                                   JSONArray messages,
                                                   String prompt) {
        String algoName = "";
        String toolName = selectedTool;
        if (selectedTool.contains(":")){
            algoName = selectedTool.split(":")[1];
            toolName = selectedTool.split(":")[0];
        }
        IntentStateHandler handler = registry.get(toolName);
        if (handler == null) {
            // 无对应处理器时回落到无意图
            handler = registry.get("default");
        }
        log.info("准备调用工具：{}",handler.getName());
        AiChatResponse intentResult = new AiChatResponse();
        intentResult.setAlgoName(algoName);

        return handler.handle(intentResult, requestParams, messages, prompt,userChatMessage.getToken());
    }
}
