package pro.spss.server.agent.service.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import pro.spss.server.agent.domain.DTO.TaskDTO;
import pro.spss.server.agent.domain.response.Result;

@FeignClient(name = "taskServiceClient", url = "${url.analysis}")
public interface TaskServiceClient {

    @PostMapping(value = "/task/exec")
    Result callExec(@RequestBody TaskDTO taskDTO, @RequestHeader(name = "Authorization",required = true) String Token);
}
