package pro.spss.server.agent.mapper;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import pro.spss.server.agent.domain.pojo.DaAgentSession;

import java.util.Date;
import java.util.List;

@Mapper
public interface DaAgentSessionMapper {
    int insert(DaAgentSession session);
    int update(DaAgentSession session);
    DaAgentSession findById(@Param("sessionId") Long sessionId);
    List<DaAgentSession> findByUser(@Param("userId") String userId,
                                    @Param("offset") int offset,
                                    @Param("limit") int limit,
                                    @Param("status") Integer status);
    int countByUser(@Param("userId") String userId,
                    @Param("status") Integer status);
    int softDelete(@Param("sessionId") Long sessionId);
    DaAgentSession findLatestActiveByUser(@Param("userId") String userId);
    int updateTitle(@Param("sessionId") Long sessionId, @Param("title") String title);
    int deleteEmptyOlderThan(@Param("userId") String userId, @Param("cutoff") Date cutoff);
}
