package pro.spss.server.agent.mapper;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import pro.spss.server.agent.domain.pojo.DaAgentMessage;

import java.util.List;

@Mapper
public interface DaAgentMessageMapper {
    int insert(DaAgentMessage message);
    List<DaAgentMessage> listBySession(@Param("sessionId") Long sessionId,
                                       @Param("offset") int offset,
                                       @Param("limit") int limit,
                                       @Param("role") String role);
    int countBySession(@Param("sessionId") Long sessionId,
                       @Param("role") String role);

    int updateById(DaAgentMessage message);

    DaAgentMessage findLastByRole(@Param("sessionId") Long sessionId, @Param("role") String role);
    int deleteLastAssistantBySession(@Param("sessionId") Long sessionId);
}
