package pro.spss.server.agent.exception;


/**
 * @ClassName: BaseException
 * @Description: 自定义基础Exception
 * @Author: wzc
 * @Date: 2023/11/24 13:47
 */
public abstract class BaseException extends Exception {

    private int code;
    private String errorMessage;

    public BaseException(int code, String errorMessage) {
        super();
        this.code = code;
        this.errorMessage = errorMessage;
   }

    public int getCode() {
        return code;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public BaseException withErrMessage(String message) {
        this.errorMessage = message;
        return this;
    }

    @Override
    public String toString() {
        return "BaseException{" +
                "code=" + code +
                ", errorMessage='" + errorMessage + '\'' +
                '}';
    }
}
