package pro.spss.server.agent.domain.request;

import com.alibaba.fastjson2.JSONArray;
import lombok.Data;
import pro.spss.server.agent.domain.enums.ConversationStateEnum;

/**
 * @author: wn
 * @Desc
 * @create: 2025-03-06-10:59
 **/

@Data
public class RequestParams {

    private String dataId;
    private String dataVersionId;
    private String algoId;
    private String algoName;
    private int createWay;
    private JSONArray params;
    private ConversationStateEnum state = ConversationStateEnum.INTENT_RECOGNITION;

    private boolean dataIdUpdated = false;
    private boolean dataVersionIdUpdated = false;
    private boolean confirmed = false;

    // 新增字段
    private boolean dataHandled = false;

    private String dataSummary; // 数据概要（列类型+示例），供自动参数生成使用


//    public void updateDataId(String dataId) {
//        if (!this.dataIdUpdated && dataId != null) {
//            this.dataId = dataId;
//            this.dataIdUpdated = true;
//        }
//    }

    public void updateDataId(String dataId) {
        if (dataId != null) {
            this.dataId = dataId;
        }
    }


//    public void updateDataVersionId(String dataVersionId) {
//        if (!this.dataVersionIdUpdated && dataVersionId != null) {
//            this.dataVersionId = dataVersionId;
//            this.dataVersionIdUpdated = true;
//        }
//    }

    public void updateDataVersionId(String dataVersionId) {
        if (dataVersionId != null) {
            this.dataVersionId = dataVersionId;
        }
    }

    public void updateAlgoId(String algoId) {
        if (algoId != null) {
            this.algoId = algoId;
        }
    }

    public void updateAlgoName(String algoName) {
        if (algoName != null) {
            this.algoName = algoName;
        }
    }

    public void updateParams(JSONArray params) {
        if (params != null) {
            this.params = params;
        }
    }

    public int getStateCode() {
        return state.getCode();
    }

    // 新增dataHandled的getter和setter
    public boolean isDataHandled() {
        return dataHandled;
    }

    public void setDataHandled(boolean dataHandled) {
        this.dataHandled = dataHandled;
    }

    public String getDataSummary() {
        return dataSummary;
    }

    public void setDataSummary(String dataSummary) {
        this.dataSummary = dataSummary;
    }
}
