package pro.spss.server.agent.domain.pojo;

import lombok.Data;

import java.util.Date;

@Data
public class DaAgentMessage {
    private Long messageId;
    private Long sessionId;
    private String role; // 'user' or 'assistant'
    private String content;
    private String think; // 深度思考内容
    private Integer tokens;
    private String type; // 消息类型
    private String metadata; // JSON as string
    private String toolName; // 调用的工具名称
    private long startTimestamp; // 调用开始时间戳
    private long endTimestamp;   // 调用结束时间戳
    private Date createdAt;
    // 新增反馈相关字段
    private Integer feedbackRating;   // 1=赞, -1=踩, 0=中立
    private String feedbackContent;   // 反馈内容
    private Boolean isCollected;      // 收藏状态：false/true
    private Date feedbackAt;          // 反馈时间
}
