package pro.spss.server.agent.domain.enums;


import lombok.Getter;
import pro.spss.server.agent.domain.response.Result;

/**
 * @author:wn
 * @Desc
 * @create: 2025-04-01-12:56
 **/
@Getter
public enum ChatStatusEnum {

    REQUESTFAILED (301, "请求失败"),
    ALGORUNFAILED (302, "算法执行失败"),
    NORESULT (304, "未收到算法执行结果"),
    RESPONSEFAILED (303, "大模型无有效回应"),
    EXECUTOR_FAILED(305, "算法提交任务失败");

    private Integer code;
    private String message;

    public Integer getCode() {
        return code;
    }

    ChatStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result toResult() {
        return Result.failed(this.code, this.message);
    }
}
