package pro.spss.server.agent.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import pro.spss.server.agent.domain.request.UserChatMessage;
import pro.spss.server.agent.domain.response.Result;
import pro.spss.server.agent.service.chatService.BaseChatService;
import pro.spss.server.common.interceptor.Authenticator;

import java.io.IOException;

@RestController
@Slf4j
@RequestMapping("/api/v1/da/smart-calls")
@Tag(name = "智能调用")
public class TestContoller {

    @Autowired
    private BaseChatService baseChat;

    @PostMapping("/analyse")
    @Operation(summary = "智能分析")
    public Result chat(@RequestBody UserChatMessage userChatMessage) throws IOException {
        String userId = Authenticator.currentUserId();
        String token = Authenticator.currentToken();
        userChatMessage.setToken(token);
        userChatMessage.setUserId(userId);
        log.info("用户提交：{}", userChatMessage);
        String userIntent = baseChat.testIntent(userChatMessage);
        return Result.success(userIntent);
    }

    @PostMapping("/clear")
    @Operation(summary = "清除历史会话记录")
    public Result clearHistory() {
        String userId = String.valueOf(Authenticator.currentUserId());
        return baseChat.clearHistory(userId);
    }

}
