package pro.spss.server.agent.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import pro.spss.server.agent.domain.request.UserChatMessage;
import pro.spss.server.agent.domain.response.Result;
import pro.spss.server.agent.service.chatService.BaseChatService;
import pro.spss.server.agent.service.handler.IntentHandlerRegistry;
import pro.spss.server.common.interceptor.Authenticator;

import java.io.IOException;


@RestController
@Slf4j
@RequestMapping("/api/v1/da/agent")
@Tag(name = "智能调用")
public class ChatController {

    @Autowired
    private BaseChatService baseChat;

    @Autowired
    private IntentHandlerRegistry intentHandlerRegistry;

    @PostMapping("/analyse")
    @Operation(summary = "智能分析")
    public Result ask(@RequestBody UserChatMessage userChatMessage) throws IOException {
        log.info("用户提交：{}", userChatMessage);
        String userId = Authenticator.currentUserId();
        String token = Authenticator.currentToken();
        userChatMessage.setToken(token);
        userChatMessage.setUserId(userId);

        log.info("用户提交：{}", userChatMessage);
        baseChat.baseChat(userChatMessage, false);
        return Result.success("提交成功");
    }

    @PostMapping("/clear")
    @Operation(summary = "清除历史会话记录")
    public Result clearHistory() {
        String userId = String.valueOf(Authenticator.currentUserId());
        return baseChat.clearHistory(userId);
    }

    @GetMapping("/tools")
    @Operation(summary = "获取所有工具信息清单（意图处理器）")
    public Result listTools() {
        return Result.success(intentHandlerRegistry.getAllToolInfos());
    }


}
