package pro.spss.server.agent.service.sessionService;

import com.alibaba.fastjson2.JSONArray;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pro.spss.server.agent.domain.constant.ChatConstants;
import pro.spss.server.agent.domain.enums.ConversationStateEnum;
import pro.spss.server.agent.domain.enums.CreateWayEnum;
import pro.spss.server.agent.domain.request.RequestParams;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 会话管理
 */
@Component
public class ChatSessionManager {
    @Getter
    private final Map<String, JSONArray> chatSessions = new ConcurrentHashMap<>();
    private final Map<String, RequestParams> sessionTaskMap = new ConcurrentHashMap<>();

    public JSONArray getMessages(String sessionId) {
        return chatSessions.get(sessionId);
    }

    public void initSession(String sessionId, CreateWayEnum createWay) {
        JSONArray messages = new JSONArray();
        messages.add(ChatConstants.createMessage(ChatConstants.ROLE_SYSTEM, ChatConstants.WELCOME_MESSAGE));
        chatSessions.put(sessionId, messages);

        RequestParams params = new RequestParams();
        params.setCreateWay(createWay.getCode());
        params.setState(ConversationStateEnum.INTENT_RECOGNITION);
        sessionTaskMap.put(sessionId, params);
    }

    public RequestParams getRequestParams(String sessionId) {
        if (sessionId == null || sessionId.isBlank()) {
            return null;
        }
        // 确保在未显式 initSession 的情况下也能获取到会话上下文，避免 NPE
        return sessionTaskMap.computeIfAbsent(sessionId, k -> {
            RequestParams params = new RequestParams();
            params.setCreateWay(CreateWayEnum.ALGO_FIRST.getCode());
            params.setState(ConversationStateEnum.INTENT_RECOGNITION);
            return params;
        });
    }

    public void clear(String sessionId) {
        chatSessions.remove(sessionId);
        sessionTaskMap.remove(sessionId);
    }
}
