package pro.spss.server.agent.service.handler.tools;

import com.alibaba.fastjson2.JSONArray;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pro.spss.server.agent.domain.constant.AlgoConfig;
import pro.spss.server.agent.domain.entity.AiChatResponse;
import pro.spss.server.agent.domain.request.RequestParams;
import pro.spss.server.agent.domain.response.ResponseMessage;
import pro.spss.server.agent.service.chatCore.ChatHelper;
import pro.spss.server.agent.service.handler.ConversationSupport;
import pro.spss.server.agent.service.prompt.PromptBuilderService;

/**
 * 默认处理器（通用意图识别）
 */

@Slf4j
@Component
public class DefaultHandler implements IntentStateHandler {

    @Autowired
    private ChatHelper chatHelper;

    @Autowired
    private PromptBuilderService promptBuilderService;

    @Autowired
    private ConversationSupport support;

    @Value("${agent.handler_result}")
    private boolean handlerResult;

    @Override
    public String getName() { return "default"; }

    @Override
    public String getTitle() { return "系统通用意图识别工具"; }

    @Override
    public String getDesc() { return "如果不属于上述工具，可以使用该工具进行简单的会话沟通。"; }

    @Override
    public String exampleUserPrompt() {
        return "明天天气怎么样？";
    }

    @Override
    public String getCondition() {
        return "无";
    }

    @Override
    public ResponseMessage handle(AiChatResponse intentResult, RequestParams requestParams, JSONArray historyMessages, String prompt, String token) {
        // 调用大模型识别
        String intentPrompt = promptBuilderService.build(AlgoConfig.SMART_CHAT_PROMPT);
        ResponseMessage msg = support.sendRequestWithHistoryMessages(historyMessages, intentPrompt, prompt);
        return msg;

    }
}
