package pro.spss.server.agent.domain.response;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import pro.spss.server.agent.domain.enums.ResultCodeEnum;


//设置统一资源返回结果集
@Data
@Schema(name = "Result全局统一返回结果")
public class Result {

    @Schema(description = "返回码")
    private  Integer code;
    @Schema(description = "返回消息")
    private  String message;
    @Schema(description = "是否成功")
    private  Boolean success;
    @Schema(description = "返回数据")
    private Object data;

    private Result() {}

    public Result(Integer newCode, String newMessage, Boolean newSuccess, Object newData) {
        this.code = newCode;
        this.message = newMessage;
        this.success = newSuccess;
        this.data = newData;
    }

    public Result(Object data, String failed, boolean b) {
        this.code = code;
        this.message = message;
        this.success = success;
        this.data = data;
    }

    public Result(ResultCodeEnum resultCodeEnum, Object data) {
        this.code = resultCodeEnum.getCode();
        this.message = resultCodeEnum.getMessage();
        this.success = resultCodeEnum.isSuccess();
        this.data = data;
    }

    //返回成功的结果集
    public static Result success(){
        Result r = new Result();
        r.setSuccess(ResultCodeEnum.SUCCESS.isSuccess());
        r.setCode(ResultCodeEnum.SUCCESS.getCode());
        r.setMessage(ResultCodeEnum.SUCCESS.getMessage());
        return r;
    }

    public static Result analysisSuccess(Object data){
        Result r = new Result();
        r.setSuccess(ResultCodeEnum.ANALYSIS_SUCCESS.isSuccess());
        r.setCode(ResultCodeEnum.ANALYSIS_SUCCESS.getCode());
        r.setMessage(ResultCodeEnum.ANALYSIS_SUCCESS.getMessage());
        r.setData(data);
        return r;
    }

    //返回带参的成功结果集
    public static Result success(Object data) {
        Result r = new Result();
        r.setSuccess(ResultCodeEnum.SUCCESS.isSuccess());
        r.setCode(ResultCodeEnum.SUCCESS.getCode());
        r.setMessage(ResultCodeEnum.SUCCESS.getMessage());
        r.setData(data);
        return r;
    }



    //返回失败的结果集
    public static Result failed(Result result) {
        Result r = new Result();
        r.setSuccess(ResultCodeEnum.UNKNOWN_REASON.isSuccess());
        r.setCode(ResultCodeEnum.UNKNOWN_REASON.getCode());
        r.setMessage(ResultCodeEnum.UNKNOWN_REASON.getMessage());
        return r;
    }

    public static Result failed(int code, String message) {
        Result r = new Result();
        r.setSuccess(false);
        r.setCode(code);
        r.setMessage(message);
        return r;
    }

    public static Result failed(int code, String message, Object data) {
        Result r = new Result();
        r.setSuccess(false);
        r.setCode(code);
        r.setMessage(message);
        r.setData(data);
        return r;
    }

    /**
     * @return
     */
    public static Result setResult( ResultCodeEnum resultCodeEnum){
        Result r = new Result();
        r.setSuccess(resultCodeEnum.isSuccess());
        r.setCode(resultCodeEnum.getCode());
        r.setMessage(resultCodeEnum.getMessage());
        return r;
    }

    public Result success(Boolean success){
        this.setSuccess(success);
        return this;
    }

    public Result message(String message){
        this.setMessage(message);
        return this;
    }

    public Result code(Integer code){
        this.setCode(code);
        return this;
    }
    public Result data(Object data) {
        this.data = data;
        return this;
    }

}
