package pro.spss.server.agent.domain.response;

import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import pro.spss.server.agent.domain.enums.ResponseMessageType;

/**
 * @author:wn
 * @Desc
 * @create: 2025-03-24-17:24
 **/
@Data
public class ResponseMessage {
    private Long messageId;
    private String sessionId;

    private String response;

    private String think; //深度思考内容
    private Integer totalToken;

    private Object options;

    private Integer code;

    private String type = ResponseMessageType.MESSAGE.getType();  // 消息类型 "message/result/config"
    private String message; // 消息内容
    private long startTimestamp; //开始时间
    private long endTimestamp; //结束时间
    private String userId;
    private JSONObject result;

    public ResponseMessage() {
        startTimestamp = System.currentTimeMillis();
    }
}
