package pro.spss.server.agent.domain.enums;

import lombok.Getter;

/**
 * @author:wn
 * @Desc
 * @create: 2024-01-16-20:52
 **/
@Getter
public enum TaskStatusEnum {

    WAITING(0, "等待中"),
    VALIDATION_FAILED(1, "校验失败"),
    IN_PROGRESS(2, "执行中"),
    SUCCESS(3, "执行成功"),
    SUCCESS_WITH_WARNING(4, "执行成功但有警告"),
    FAILED(5, "执行失败");

    private Integer code;
    private String message;

    public Integer getCode() {
        return code;
    }

    TaskStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
