package pro.spss.server.agent.domain.enums;

import lombok.Getter;


/**
 * @author:wn
 * @Desc
 * @create: 2025-03-20-16:07
 **/
@Getter
public enum ResultCodeEnum {

    SUCCESS(true, 200, "成功"),
    BASE_ERROR(false,500, "后端异常"),
    ANALYSIS_SUCCESS(true, 201, "创建分析任务成功"),
    UNKNOWN_REASON(false, 20001, "未知错误"),
    INVALIDREQUEST(false, 20002, "无效请求"),
    INVALIDTOKEN(false, 22001, "无效token"),
    ILLEGALPASSWARD(false, 22002, "密码错误"),
    FORBIDDENACCESS(false, 22003, "无效凭证"),
    VALIDATIONERROR(false, 23001, "算法调用异常"),
    DOWNLOAD_ERROR(false, 24001, "下载异常"),
    SAVE_ChART_FAIL(false, 25001, "保存图片失败");



    private boolean success;
    private Integer code;
    private String message;
    private Object data;


    private ResultCodeEnum(Boolean success, Integer code, String message) {
        this.success = success;
        this.code = code;
        this.message = message;
    }
}

