package pro.spss.server.agent.domain.enums;

/**
 * @author:wn
 * @Desc
 * @create: 2025-06-17-15:59
 **/
public enum ConversationStateEnum {
    NO_DATA_INTENT_RECOGNITION(0), //未上传数据之前的闲聊以及引导阶段
    INTENT_RECOGNITION(1),       // 意图识别阶段
    PARAM_RECOMMENDATION(2),      // 算法参数配置推荐阶段
    PARAM_CONFIRMATION(3),        // 参数确认阶段
    PARAM_MODIFICATION(4),        // 参数修改阶段
    USER_CONFIREM_RUNTASK(5),     // 用户已确认可以执行算法
    DEFAULT(99);                  // 默认状态

    private final int code;

    // 构造器名必须和枚举名一致
    ConversationStateEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    // 根据int获取对应枚举
    public static ConversationStateEnum fromCode(int code) {
        for (ConversationStateEnum state : ConversationStateEnum.values()) {
            if (state.getCode() == code) {
                return state;
            }
        }
        return DEFAULT;
    }
}
