package pro.spss.server.agent.domain.constant;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

/**
 * @author:wn
 * @Desc
 * @create: 2024-12-31-14:00
 **/
public class ChatConstants {
    public static final String USER_ROLE = "user";

    public static final String ROLE_SYSTEM = "system";

    public static final double TEMPERATURE = 1.0;

    public static final String CONTENT = "content";

    public static final String RESPONSE = "response";

    public static final String PARAMS = "params";

    public static final String OPTIONS = "options";

    public static final String MESSAGE = "message";

    public static final String USER_PROMPT = "\n【用户需求】\n";

    public static final String DATA_STATUS = "【当前状态】";

    public static final String DATA_PROMPT = "【数据内容】";

    public static final String WELCOME_MESSAGE = "您好，我是数据分析机器人，根据您上传的数据和需求为您推荐合适的算法和参数配置，请问您想分析什么?";

    public static final String MARKDOWN = "(?i)```json\\s*|```\\s*";

    public static final JSONArray SYSTEM_MESSAGES = initSystemMessage();

    private static JSONArray initSystemMessage() {
        return new JSONArray();
    }

    public static JSONObject createMessage(String role, String content) {
        JSONObject message = new JSONObject();
        message.put("role", role);
        message.put("content", content);
        return message;
    }

}



